﻿using System;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;

namespace VIRP_WEB.Custom.EFR
{
    public class ImagingBasePage : EfrBasePage
    {
        protected const string DateFormat = "M/d/yyyy";
        protected const string OriginallyNavigatedFrom = "OriginallyNavigatedFrom";

        public bool AuthorizedUser()
        {
            return (UserSession.IsRegistryAdministrator || UserSession.IsRegistryUpdate || UserSession.IsRegistryRead);
        }

        protected bool? GetDropDownListBooleanValue(DropDownList list)
        {
            return list.SelectedIndex > 0 ? list.SelectedIndex == 1 : (bool?)null;
        }

        protected int? GetDropDownSelectedIndex(DropDownList list)
        {
            int? result = null;

            if (list.SelectedIndex > 0)
                result = list.SelectedIndex;

            return result;
        }

        protected string GetStringValueFromTextBox(TextBox textBox)
        {
            return string.IsNullOrEmpty(textBox.Text) ? null : textBox.Text;
        }

        protected decimal? GetDecimalValueFromTextBox(TextBox textBox)
        {
            return string.IsNullOrEmpty(textBox.Text) ? (decimal?)null : decimal.Parse(textBox.Text);
        }

        protected decimal? GetDecimalValueFromTextBox(HtmlInputText textBox)
        {
            return string.IsNullOrEmpty(textBox.Value) ? (decimal?)null : decimal.Parse(textBox.Value);
        }

        protected DateTime? GetDateTimeValueFromTextBox(TextBox textBox)
        {
            return string.IsNullOrEmpty(textBox.Text) ? (DateTime?)null : DateTime.Parse(textBox.Text);
        }
    }
}